declare default element namespace 'http://пф.рф/ВС/СЗВ-М/2016-01-01';declare namespace УТ = "http://пф.рф/унифицированныеТипы/2014-01-01";
declare namespace АФ = "http://пф.рф/АФ";
declare variable $document as node()* external;
declare variable $root:=root($document)/ЭДПФР;
declare variable $szv:=$root/СЗВ-М;
declare variable $fio:=$szv//ФИО;
declare function local:nodeIndex($nodes as node()*, $nodeToFind as node()) as xs:integer
{
for $seq in (1 to count($nodes))
				return $seq[$nodes[$seq] is $nodeToFind]
};
declare function local:nodePosition($node as node()?) as xs:string
{
string-join(
					for $ancestor in $node/ancestor-or-self::*
					let $sibsOfSameName := $ancestor/../*[name()=name($ancestor)]
					return concat(name($ancestor),
						if (count($sibsOfSameName)<= 1) then '' else concat('[',local:nodeIndex($sibsOfSameName,$ancestor),']')),
						'/'
				)
};
declare function local:all-whitespace($arg as xs:string?) as xs:boolean
{
normalize-space($arg) = ''
};
declare function local:isEmpty($element) as xs:boolean
{
local:all-whitespace(string($element))
};
declare function local:notExistsOrEmpty($element) as xs:boolean
{
not(exists($element)) or local:isEmpty($element)
};
<БлокПроверок ID="ВСЗЛ.ФИО.1" name="Блок логических правил проверки фамилии, имени, отчества">
<Проверка ID="1">
<Описание>Должен быть указан хотя бы один из элементов 'Фамилия' или 'Имя'</Описание>
<РезультатЗапроса>
{
				if (count($fio) > 0) then
					for $f in $fio
						return if (local:notExistsOrEmpty($f/УТ:Фамилия) and local:notExistsOrEmpty($f/УТ:Имя)) then
							local:nodePosition($f)
						else '0'
				else '0'
			}
</РезультатЗапроса>
<КодРезультата>30</КодРезультата>
</Проверка>
<Проверка ID="2">
<Описание>В элементах 'Фамилия', 'Имя', 'Отчество' знак '-' не может быть последним символом элемента</Описание>
<РезультатЗапроса>
{
				if (count($fio) > 0) then
					for $f in $fio
						return if (count($f/child::*) > 0) then
							for $c in $f/child::*
								return if (ends-with($c,'-')) then
									local:nodePosition($c)
								else '0'
						else '0'
				else '0'
			}
</РезультатЗапроса>
<КодРезультата>40</КодРезультата>
</Проверка>
<Проверка ID="3">
<Описание>Элемент 'Отчество' должен быть заполнен</Описание>
<РезультатЗапроса>
{
				if (count($fio) > 0) then
					for $f in $fio
						return if (not(local:notExistsOrEmpty($f/УТ:Отчество))) then '0'
						else local:nodePosition($f)
				else '0'
			}
</РезультатЗапроса>
<КодРезультата>20</КодРезультата>
</Проверка>
<Проверка ID="4">
<Описание>Во всех документах в элементах Фамилия, Имя, Отчество допустимы только следующие символы и их сочетания:
					- буквы русского алфавита, в том числе буква 'Ё'
				- знак '–'
			</Описание>
<РезультатЗапроса>
{
				if (count($fio) > 0) then
					for $f in $fio
						return if (count($f/child::*) > 0) then
							for $c in $f/child::*
								return if (matches($c, "^[А-Яа-яЁё \-\.']*$")) then '0'
								else local:nodePosition($c)
						else '0'
				else '0'
			}
</РезультатЗапроса>
<КодРезультата>40</КодРезультата>
</Проверка>
<Проверка ID="5">
<Описание>Во всех документах в элементах Фамилия, Имя, Отчество латинские буквы допускаются</Описание>
<РезультатЗапроса>
{
				if (count($fio) > 0) then
					for $f in $fio
						return if (count($f/child::*) > 0) then
							for $c in $f/child::*
								return if (matches($c, "^[a-zA-Z \-\.']*$")) then local:nodePosition($c)
								else '0'
						else '0'
				else '0'
			}
</РезультатЗапроса>
<КодРезультата>10</КодРезультата>
</Проверка>
<Проверка ID="6">
<Описание>Во всех документах в элементах Фамилия, Имя, Отчество знаки '–' не могут идти подряд или через пробел</Описание>
<РезультатЗапроса>
{
				if (count($fio) > 0) then
					for $f in $fio
						return if (count($f/child::*) > 0) then
							for $c in $f/child::*
								return if (contains($c, '--') or contains($c, '- -')) then local:nodePosition($c)
								else '0'
						else '0'
				else '0'
			}
</РезультатЗапроса>
<КодРезультата>30</КодРезультата>
</Проверка>
<Проверка ID="7">
<Описание>Во всех документах в элементах Фамилия, Имя, Отчество: не допускается смешение в этих элементах букв русского и латинского алфавитов</Описание>
<РезультатЗапроса>
{
				if (count($fio) > 0) then
					for $f in $fio
						return if (count($f/child::*) > 0) then
							for $c in $f/child::*
								return if (matches($c, "^[a-zA-Z \-\.']*$") or matches($c, "^[А-Яа-яЁё \-\.']*$")) then '0'
								else local:nodePosition($c)
						else '0'
				else '0'
			}
</РезультатЗапроса>
<КодРезультата>20</КодРезультата>
</Проверка>
<Проверка ID="8">
<Описание>В элементе 'Фамилия' точка '.' не допускается</Описание>
<РезультатЗапроса>
{
				if (count($fio) > 0) then
					for $f in $fio
						return if (contains($f/УТ:Фамилия, '.')) then local:nodePosition($f/УТ:Фамилия)
						else '0'
				else '0'
			}
</РезультатЗапроса>
<КодРезультата>40</КодРезультата>
</Проверка>
<Проверка ID="9">
<Описание>В элементах 'Имя' и 'Отчество' точка '.' допускается</Описание>
<РезультатЗапроса>
{
				if (count($fio) > 0) then
					for $f in $fio
						return if (not(contains($f/УТ:Имя, '.')) and (local:notExistsOrEmpty($f/УТ:Отчество) or not(contains($f/УТ:Отчество, '.')))) then '0'
						else local:nodePosition($f)
				else '0'
			}
</РезультатЗапроса>
<КодРезультата>20</КодРезультата>
</Проверка>
<Проверка ID="10">
<Описание>Во всех документах в элементах Фамилия, Имя, Отчество, знак "'" допускается</Описание>
<РезультатЗапроса>
{
				if (count($fio) > 0) then
					for $f in $fio
						return if (count($f/child::*) > 0) then
							for $c in $f/child::*
								return if (contains($c, "'")) then local:nodePosition($c)
								else '0'
						else '0'
				else '0'
			}
</РезультатЗапроса>
<КодРезультата>20</КодРезультата>
</Проверка>
<Проверка ID="11">
<Описание>В элементе Фамилия допускается открывающая и закрывающая скобки в следующей последовательности символов: фамилии1 один пробел (фамилия2)</Описание>
<РезультатЗапроса>
{
				if (count($fio) > 0) then
					for $f in $fio
						return if (not(local:notExistsOrEmpty($f/УТ:Фамилия))) then
							if (matches($f/УТ:Фамилия, "^([а-яА-ЯёЁ\-\.']*)(\s)(\([а-яА-ЯёЁ\-\.']*\))$")) then local:nodePosition($f/УТ:Фамилия)
							else '0'
						else '0'
				else '0'
			}
</РезультатЗапроса>
<КодРезультата>20</КодРезультата>
</Проверка>
</БлокПроверок>

